; computerised.nsi
;
; This installs computerised carnival.
;

; The name of the installer
Name "Computerised Carnival - Primary Edition"

; Sets icon - not working at present
; Icon cc.ico

; Does a crc check - no corruption :)
crccheck on

; The file to write
OutFile "ccarninspri.exe"

; The default installation directory
InstallDir "$PROGRAMFILES\Computerised Carnival"

LicenseText "You must read the following license before installing:"
LicenseData license.txt

;ComponentText "This will install Computerised Carnival v1.6.0 onto your computer."
;ShowInstDetails show

Page license
Page directory
Page instfiles


; The stuff to install
Section "Computerised Carnival"
  ; Set output path to the installation directory.
  SetOutPath $INSTDIR

  ; Copies files
  File /R "primary\*.*"
  File /R "bin\*.*"


; The uninstall file name
WriteUninstaller nsuninst.exe
;UninstallText "This will uninstall Computerised Carnival from your system, click cancel if you do not wish to do so."

  ; Does start menu and desktop
  CreateDirectory "$SMPROGRAMS\Computerised Carnival"
  CreateShortCut "$SMPROGRAMS\Computerised Carnival\Computerised Carnival.lnk" "$INSTDIR\Computerised Carnival.exe" "" "$INSTDIR\Computerised Carnival.exe" 0
CreateShortCut "$SMPROGRAMS\Computerised Carnival\Edit Records.lnk" "$INSTDIR\RecordEdit.exe" "" "$INSTDIR\RecordEdit.exe" 0  
CreateShortCut "$SMPROGRAMS\Computerised Carnival\Record Backup and Restore.lnk" "$INSTDIR\backuprestore.exe" "" "$INSTDIR\backuprestore.exe" 0  
CreateShortCut "$SMPROGRAMS\Computerised Carnival\Record Generator.lnk" "$INSTDIR\RecordGen.exe" "" "$INSTDIR\RecordGen.exe" 0  

  CreateShortCut "$SMPROGRAMS\Computerised Carnival\Quick Reference.lnk" "$INSTDIR\help\quickref.pdf" "" "$INSTDIR\help\quickref.pdf" 0
  CreateShortCut "$SMPROGRAMS\Computerised Carnival\Help.lnk" "$INSTDIR\help\index.htm" "" "$INSTDIR\help\index.htm" 0
  CreateShortCut "$SMPROGRAMS\Computerised Carnival\Readme and Erratum.lnk" "$INSTDIR\help\readme.txt" "" "$INSTDIR\help\readme.txt" 0
  CreateShortCut "$SMPROGRAMS\Computerised Carnival\Uninstall.lnk" "$INSTDIR\nsuninst.exe" "" "$INSTDIR\nsuninst.exe" 0

  CreateShortCut "$DESKTOP\Computerised Carnival.lnk" "$INSTDIR\Computerised Carnival.exe" "" "$INSTDIR\Computerised Carnival.exe" 0  

  ; Write the installation path into the registry
  WriteRegStr HKLM SOFTWARE\Computerised_Carnival "Install_Dir" "$INSTDIR"
  ; Write the uninstall keys for Windows
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Computerised_Carnival" "DisplayName" "Computerised Carnival"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Computerised_Carnival" "UninstallString" '"$INSTDIR\nsuninst.exe"'
  WriteRegStr HKU ".Default\Software\VB and VBA Settings\Compcarn\Settings" "Path" '"$INSTDIR\help\index.htm"'



SectionEnd

Function .onInstSuccess
  MessageBox MB_YESNO|MB_ICONQUESTION \
             "Setup has completed. View readme file now?" \
             IDNO NoReadme
    ExecShell open '$INSTDIR\help\readme.txt'
  NoReadme:
FunctionEnd


; Uninstall

Section "Uninstall"
  SetDetailsView show
  MessageBox MB_YESNO "Are you sure you want to uninstall Computerised Carnival?" IDYES NoAbort
    Abort "Uninstall aborted by user"
  NoAbort:

  ; Deletes registry keys
  DeleteRegKey HKLM SOFTWARE\Computerised_Carnival
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Computerised_Carnival"
  
  ; Deletes files
  Delete "$INSTDIR\*.*"
  Delete "$INSTDIR\data\swimming\12\*.*"
  Delete "$INSTDIR\data\swimming\13\*.*"
  Delete "$INSTDIR\data\swimming\14\*.*"
  Delete "$INSTDIR\data\swimming\15\*.*"
  Delete "$INSTDIR\data\swimming\16\*.*"
  Delete "$INSTDIR\data\swimming\17+\*.*"
  Delete "$INSTDIR\data\athletics\12\*.*"
  Delete "$INSTDIR\data\athletics\13\*.*"
  Delete "$INSTDIR\data\athletics\14\*.*"
  Delete "$INSTDIR\data\athletics\15\*.*"
  Delete "$INSTDIR\data\athletics\16\*.*"
  Delete "$INSTDIR\data\athletics\17+\*.*"
  Delete "$INSTDIR\data\athletics\*.*"
  Delete "$INSTDIR\data\swimming\*.*"
  Delete "$INSTDIR\data\*.*"
  Delete "$INSTDIR\help\*.*"

  Delete "$INSTDIR\pristi~1\swimming\12\*.*"
  Delete "$INSTDIR\pristi~1\swimming\13\*.*"
  Delete "$INSTDIR\pristi~1\swimming\14\*.*"
  Delete "$INSTDIR\pristi~1\swimming\15\*.*"
  Delete "$INSTDIR\pristi~1\swimming\16\*.*"
  Delete "$INSTDIR\pristi~1\swimming\17+\*.*"
  Delete "$INSTDIR\pristi~1\athletics\12\*.*"
  Delete "$INSTDIR\pristi~1\athletics\13\*.*"
  Delete "$INSTDIR\pristi~1\athletics\14\*.*"
  Delete "$INSTDIR\pristi~1\athletics\15\*.*"
  Delete "$INSTDIR\pristi~1\athletics\16\*.*"
  Delete "$INSTDIR\pristi~1\athletics\17+\*.*"
  Delete "$INSTDIR\pristi~1\athletics\*.*"
  Delete "$INSTDIR\pristi~1\swimming\*.*"
  Delete "$INSTDIR\pristi~1\*.*"

  ; MUST REMOVE UNINSTALLER, too
  Delete $INSTDIR\nsuninst.exe
  ; remove shortcuts, if any.
  Delete "$SMPROGRAMS\Computerised Carnival\*.*"
  ; Deletes shortcut on desktop
  Delete "$DESKTOP\Computerised Carnival.lnk"
  ; remove directories used.
  RMDir "$SMPROGRAMS\Computerised Carnival"
  RMDir /R "$INSTDIR"
SectionEnd

; eof
